/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs.impl;

import com.ibm.hwmca.fw.connmgr.Connection;
import com.ibm.hwmca.fw.connmgr.ConnectionGroup;
import com.ibm.hwmca.fw.connmgr.ConnectionHandler;
import com.ibm.hwmca.fw.fcs.impl.ServiceThread;
import com.ibm.hwmca.fw.fcs.impl.stream.StreamConstants;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.util.Map;

public class FcsConnectionHandler
implements ConnectionHandler,
StreamConstants {
    private static final String TRACE_MASKD = "XFCSCNHD";
    private static final String TRACE_MASKF = "XFCSCNHF";
    private static final String TRACE_MASKT = "XFCSCNHT";

    public FcsConnectionHandler() {
        Trace.trace(TRACE_MASKT, "<> FcsConnectionHandler");
    }

    public void handleUnAuthenticated(ConnectionGroup group, Serializable parm) {
        Trace.trace(TRACE_MASKT, "-> handleUnAuthenticated()");
        this.log("Unauthenticated: doing nothing");
        Connection[] connections = group.getConnections();
        for (int i = 0; i < connections.length; ++i) {
            connections[i].close();
        }
        Trace.trace(TRACE_MASKT, "<- handleUnAuthenticated()");
    }

    public void handleAuthenticated(ConnectionGroup group, Serializable parm) {
        Trace.trace(TRACE_MASKT, "-> handleAuthenticated()");
        if (parm != null && parm instanceof Map) {
            new ServiceThread(group.getConnections()[0], (Map)((Object)parm)).process();
        } else {
            this.log("Parm wasn't a map");
        }
        Trace.trace(TRACE_MASKT, "<- handleAuthenticated()");
    }

    public void handleNewConnection(Connection connection, Serializable parm) {
        Trace.trace(TRACE_MASKT, "-> handleNewConnection()");
        if (parm != null && parm instanceof Map) {
            new ServiceThread(connection, (Map)((Object)parm)).process();
        } else {
            this.log("Parm wasn't a map");
        }
        Trace.trace(TRACE_MASKT, "<- handleNewConnection()");
    }

    private void log(String msg) {
        Trace.trace(TRACE_MASKF, "FcsConnectionHandler.log(): " + msg);
    }
}

